/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.sequenced;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAssemblyRecipeNames;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.foundation.recipe.ComponentsIngredient;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.component.SequencedAssemblyJunk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9696;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.util.TriConsumer;

public record SequencedAssemblyRecipe(class_1856 ingredient, class_1799 transitionalItem, ProcessingOutput result, List<ProcessingOutput> junks, int loops, List<class_1860<?>> sequence) implements CreateRecipe<class_9696>
{
    public class_3956<SequencedAssemblyRecipe> method_17716() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY;
    }

    public boolean matches(class_9696 input, class_1937 world) {
        return this.ingredient.method_8093(input.comp_2676());
    }

    public class_1799 assemble(class_9696 input, class_7225.class_7874 registries) {
        return this.result.create();
    }

    public class_1865<? extends class_1860<class_9696>> method_8119() {
        return AllRecipeSerializers.SEQUENCED_ASSEMBLY;
    }

    public static class Serializer
    implements class_1865<SequencedAssemblyRecipe> {
        private static final Codec<List<ProcessingOutput>> JUNKS_CODEC = ProcessingOutput.CODEC.listOf();
        private static final Codec<List<class_1860<?>>> RECIPE_CODEC = class_1860.field_47319.listOf();
        private static final MapCodec<SequencedAssemblyRecipe> RAW_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("ingredient").forGetter(SequencedAssemblyRecipe::ingredient), (App)class_1799.field_24671.fieldOf("transitional_item").forGetter(SequencedAssemblyRecipe::transitionalItem), (App)ProcessingOutput.CODEC.fieldOf("result").forGetter(SequencedAssemblyRecipe::result), (App)JUNKS_CODEC.optionalFieldOf("junks", List.of()).forGetter(SequencedAssemblyRecipe::junks), (App)Codec.INT.optionalFieldOf("loops", (Object)1).forGetter(SequencedAssemblyRecipe::loops), (App)RECIPE_CODEC.fieldOf("sequence").forGetter(SequencedAssemblyRecipe::sequence)).apply((Applicative)instance, SequencedAssemblyRecipe::new));
        private static final String INGREDIENT_ID = "$ingredient";
        private static final String RESULT_ID = "$result";
        private static final AtomicInteger idGenerator = new AtomicInteger();
        public static final Map<class_2960, class_1860<?>> GENERATE_RECIPES = new HashMap();
        public static final MapCodec<SequencedAssemblyRecipe> CODEC = new MapCodec<SequencedAssemblyRecipe>(){

            public <T> RecordBuilder<T> encode(SequencedAssemblyRecipe input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                prefix.add("raw", ops.createBoolean(true));
                return RAW_CODEC.encode((Object)input, ops, prefix);
            }

            public <T> DataResult<SequencedAssemblyRecipe> decode(DynamicOps<T> dynamicOps, MapLike<T> input) {
                if (input.get("raw") == null) {
                    Object object = input.get("sequence");
                    if (!(object instanceof JsonArray)) {
                        throw new UnsupportedOperationException("ops must be a JsonOps");
                    }
                    JsonArray sequenceJson = (JsonArray)object;
                    DynamicOps ops = dynamicOps;
                    int loops = Optional.ofNullable(input.get("loops")).map(value -> dynamicOps.getNumberValue(value, (Number)1).intValue()).orElse(1);
                    int sequenceSize = sequenceJson.size();
                    int size = sequenceSize * loops;
                    if (size <= 1) {
                        throw new UnsupportedOperationException("sequence must have at least two steps");
                    }
                    class_1799 transitionalItem = (class_1799)class_1799.field_24671.parse(dynamicOps, input.get("transitional_item")).getOrThrow();
                    ProcessingOutput result = (ProcessingOutput)ProcessingOutput.CODEC.parse(dynamicOps, input.get("result")).getOrThrow();
                    List<ProcessingOutput> junks = JUNKS_CODEC.parse(dynamicOps, input.get("junks")).result().orElse(List.of());
                    ArrayList<class_2561> RecipeName = new ArrayList<class_2561>(sequenceSize);
                    for (int i2 = 0; i2 < sequenceSize; ++i2) {
                        RecipeName.add(AllAssemblyRecipeNames.get(ops, sequenceJson.get(i2)));
                    }
                    class_1799 transitional = transitionalItem.method_7972();
                    class_1856 transitionalIngredient = class_1856.method_8101((class_1935)transitionalItem.method_7909());
                    Supplier<JsonElement> transitionalJsonIngredient = () -> (JsonElement)ComponentsIngredient.CODEC.encodeStart(ops, (Object)new ComponentsIngredient(transitionalIngredient, transitional.method_57380())).getOrThrow();
                    ArrayList<BiFunction<JsonElement, JsonElement, JsonObject>> sequenceJsonFactory = new ArrayList<BiFunction<JsonElement, JsonElement, JsonObject>>(size);
                    for (int i3 = 0; i3 < sequenceSize; ++i3) {
                        JsonObject object2 = (JsonObject)sequenceJson.get(i3);
                        Consumer<JsonElement> replaceIngredient = 1.getReplace(object2, Serializer.INGREDIENT_ID);
                        Consumer<JsonElement> replaceResult = 1.getReplace(object2, Serializer.RESULT_ID);
                        sequenceJsonFactory.add((ingredientJson, resultJson) -> {
                            if (replaceIngredient != null) {
                                replaceIngredient.accept((JsonElement)ingredientJson);
                            }
                            if (replaceResult != null) {
                                replaceResult.accept((JsonElement)resultJson);
                            }
                            return object2;
                        });
                    }
                    MutableInt step = new MutableInt(1);
                    Supplier<JsonElement> transitionalJsonResult = () -> {
                        int i;
                        int index = step.getAndIncrement();
                        ArrayList<Object> lore = new ArrayList<Object>(6);
                        lore.add(class_5244.field_39003);
                        lore.add(class_2561.method_43471((String)"create.recipe.sequenced_assembly").method_27692(class_124.field_1080).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
                        lore.add(class_2561.method_43469((String)"create.recipe.assembly.progress", (Object[])new Object[]{index, size}).method_27692(class_124.field_1063).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
                        lore.add(class_2561.method_43469((String)"create.recipe.assembly.next", (Object[])new Object[]{RecipeName.get(index % sequenceSize)}).method_27692(class_124.field_1075).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
                        int end = Math.min(i + 2, size);
                        for (i = index + 1; i < end; ++i) {
                            lore.add(class_2561.method_43470((String)"-> ").method_10852((class_2561)RecipeName.get(i % sequenceSize)).method_27692(class_124.field_1062).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
                        }
                        transitional.method_57379(AllDataComponents.SEQUENCED_ASSEMBLY_PROGRESS, (Object)Float.valueOf((float)index / (float)size));
                        transitional.method_57379(class_9334.field_49632, (Object)new class_9290(lore, lore));
                        return (JsonElement)class_1799.field_24671.encodeStart(ops, (Object)transitional).getOrThrow();
                    };
                    Supplier<JsonElement> transitionalJsonChanceResult = () -> {
                        transitional.method_57379(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK, (Object)new SequencedAssemblyJunk(result.chance(), junks));
                        JsonElement element = (JsonElement)transitionalJsonResult.get();
                        transitional.method_57381(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK);
                        return element;
                    };
                    JsonElement jsonResult = (JsonElement)class_1799.field_24671.encodeStart(ops, (Object)result.create()).getOrThrow();
                    class_2960 id = class_2960.method_60654((String)AllRecipeTypes.SEQUENCED_ASSEMBLY.toString()).method_48331("_" + idGenerator.incrementAndGet() + "_" + class_7923.field_41178.method_10221((Object)((class_1792)result.item().comp_349())).method_12832() + "_");
                    ArrayList sequence = new ArrayList(size);
                    TriConsumer recipeAdd = (i, ingredientJson, resultJson) -> {
                        JsonObject object = (JsonObject)((BiFunction)sequenceJsonFactory.get(i % sequenceSize)).apply(ingredientJson, resultJson);
                        class_1860 recipe = (class_1860)class_1860.field_47319.parse(ops, (Object)object).getOrThrow();
                        sequence.add(recipe);
                        GENERATE_RECIPES.put(id.method_48331(String.valueOf(sequence.size())), recipe);
                    };
                    JsonElement ingredientJson2 = (JsonElement)input.get("ingredient");
                    recipeAdd.accept((Object)0, (Object)ingredientJson2, (Object)(size == 2 ? transitionalJsonChanceResult.get() : transitionalJsonResult.get()));
                    int end = size - 2;
                    for (int i4 = 1; i4 < end; ++i4) {
                        recipeAdd.accept((Object)i4, (Object)transitionalJsonIngredient.get(), (Object)transitionalJsonResult.get());
                    }
                    if (size > 2) {
                        recipeAdd.accept((Object)(size - 2), (Object)transitionalJsonIngredient.get(), (Object)transitionalJsonChanceResult.get());
                    }
                    recipeAdd.accept((Object)(size - 1), (Object)transitionalJsonIngredient.get(), (Object)jsonResult);
                    return DataResult.success((Object)new SequencedAssemblyRecipe((class_1856)class_1856.field_46095.parse(ops, (Object)ingredientJson2).getOrThrow(), transitionalItem, result, junks, loops, sequence));
                }
                return RAW_CODEC.decode(dynamicOps, input);
            }

            private static Consumer<JsonElement> getReplace(JsonObject target, String id) {
                for (Map.Entry entry : target.entrySet()) {
                    JsonElement value = (JsonElement)entry.getValue();
                    Consumer<JsonElement> consumer = 1.getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    }
                    if (!1.match(value, id)) continue;
                    String key = (String)entry.getKey();
                    return data -> target.add(key, data);
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonArray target, String id) {
                int size = target.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement value = target.get(i);
                    Consumer<JsonElement> consumer = 1.getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    }
                    if (!1.match(value, id)) continue;
                    int index = i;
                    return data -> target.set(index, data);
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonElement target, String id) {
                if (target instanceof JsonObject) {
                    JsonObject object = (JsonObject)target;
                    return 1.getReplace(object, id);
                }
                if (target instanceof JsonArray) {
                    JsonArray array = (JsonArray)target;
                    return 1.getReplace(array, id);
                }
                return null;
            }

            private static boolean match(JsonElement target, String id) {
                JsonPrimitive primitive;
                return target instanceof JsonPrimitive && (primitive = (JsonPrimitive)target).isString() && primitive.getAsString().equals(id);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("ingredient"), ops.createString("transitional_item"), ops.createString("result"), ops.createString("junks"), ops.createString("loops"), ops.createString("sequence"));
            }
        };
        public static final class_9139<class_9129, SequencedAssemblyRecipe> PACKET_CODEC = class_9139.method_58025((class_9139)class_1856.field_48355, SequencedAssemblyRecipe::ingredient, (class_9139)class_1799.field_48349, SequencedAssemblyRecipe::transitionalItem, ProcessingOutput.STREAM_CODEC, SequencedAssemblyRecipe::result, (class_9139)ProcessingOutput.STREAM_CODEC.method_56433(class_9135.method_56363()), SequencedAssemblyRecipe::junks, (class_9139)class_9135.field_49675, SequencedAssemblyRecipe::loops, (class_9139)class_1860.field_48356.method_56433(class_9135.method_56363()), SequencedAssemblyRecipe::sequence, SequencedAssemblyRecipe::new);

        public MapCodec<SequencedAssemblyRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SequencedAssemblyRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

